/*!
  \mainpage imageTagger
  \brief Verwaltung von Bildtags

  Mit imageTagger koennen auf einfache Weise Tags von Bildern verwaltet werden.
  
  Funktionen:
  \li Bildern beliebig freie Tags zuweisen.
  \li Bilder nach Tags suchen
  \li Die Tags werden extern gespeichert, funktioniert also auch fuer Bilder auf
      CDs, oder solche die aus irgendwelchen Gruenden nicht veraendert werden
      duerfen/sollen, oder solche in derem Format metadaten nicht vorgesehen
      sind.
  \author Johannes Bretscher <bretscher@5sl.org>
  \date 2008-05-18
  
  \section Copyright Copyright notice

    Copyright (C) 2008  Johannes Bretscher

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
/*
  \file main.cpp
  \author Johannes Bretscher <bretscher@5sl.org>
  \date 2008-05-18
*/  

#include "mainwin.h"
#include <QApplication>
#include <QTranslator>
#include <QLocale>

//! Programm startet hier.
int main(int argc, char *argv[]) {


  QApplication app(argc, argv);

  QTranslator qtTranslator;
  qtTranslator.load("qt_" + QLocale::system().name());
  app.installTranslator(&qtTranslator);
   
  QTranslator translator;
  translator.load("translations/imageTagger_" + QLocale::system().name());
  app.installTranslator(&translator);

  MainWin mainWin;
  mainWin.show();
  return app.exec();
}


