#ifndef __TAGSUCHE_H__
#define __TAGSUCHE_H__
/*!
 \file tagsuche.h
 \author Johannes Bretscher <bretscher@5sl.org>
 \date 2008-06-03
*/
/*
    Copyright (C) 2008  Johannes Bretscher

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "ui_tagsuche.h"
#include "datenbank.h"
#include <QStringList>

//! \brief Eingabefenster zur Suche nach Bildern ueber Tags.
//! \todo Suchmoeglichkeiten erweitern
class Tagsuche : public QDialog {
  // Data area
  Ui::Tagsuche m_ui;	//!< Template des Fensters vom Designer
  Datenbank *m_datenbank;	//!< Tagdatenbank

  public:
  Tagsuche(Datenbank*, QWidget* =0, Qt::WindowFlags=0);

  void accept();

  signals:
  void selected(const QStringList &);

  private:
  Q_OBJECT
};

#endif
