#ifndef __MAINWIN_H__
#define __MAINWIN_H__
/*!
 \file mainwin.h
 \author Johannes Bretscher <bretscher@5sl.org>
 \date 2008-05-18
*/
/*
    Copyright (C) 2008  Johannes Bretscher

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "ui_mainwin.h"
#include "bildauswahl.h"
#include "datenbank.h"
#include "tagsuche.h"
#include "optionen.h"

/*!
  \brief Das Hauptfenster mit einer Darstellung des Spielfeldes
*/
class MainWin : public QMainWindow {
  // Data area
  Ui::MainWindow m_ui;	//!< Template des Fensters vom Designer
  QGraphicsScene *m_bild;	//!< Hier wird das Bild angezeigt
  QString m_bildname,	//!< Name des aktuellen Bildes
  	m_path;	//!< Pfad des Bildverzeichnises
  Datenbank *m_datenbank;	//!< Die Tagdatenbank
  Bildauswahl *m_bildauswahl;	//!< Verwaltungsleiste der Bilderliste
  bool m_dirty;	//!< Tags zu aktuellem Bild wurden geaendert.
  Tagsuche *m_tagsuche;	//!< Fenster zur Suche nach bestimmten Tags

  public:
  MainWin(QWidget* =0);

  private slots:
  void newPicture();
  void saveData();
  void zoomIn();
  void zoomOut();
  void newTag();
  void displayPicture(const QString&);
  void setDirty();
  void search();
  void newPictureList(const QStringList &);
  void options();
  

  private:
  Q_OBJECT
};

#endif
