#ifndef __OPTIONEN_H__
#define __OPTIONEN_H__
/*!
 \file optionen.h
 \author Johannes Bretscher <bretscher@5sl.org>
 \date 2008-08-30
*/
/*
    Copyright (C) 2008  Johannes Bretscher

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "ui_optionen.h"
#include <QSettings>

/*!
  Anzeigemoeglichkeiten fuer neu geladene Bilder
*/ 
enum DisplayMode {
  DM_ORIGINAL,	//!< Bild in Originalgroesse anzeigen
  DM_WIDTH,	//!< Bildbreite an Fenster anpassen
  DM_MAXWIDTH,	//!< Bildbreite an Fenster anpassen, wenn Bild breiter
  DM_HEIGHT,	//!< Bildhoehe an Fenster anpassen
  DM_MAXHEIGHT	//!< Bildhoehe an Fenster anpassen, wenn Bild hoeher
};

//! \brief Einstellen der Optionen des Programms
class Optionen : public QDialog {
  // Data area
  Ui::Optionen m_ui;	//!< Template des Fensters vom Designer

  public:
  Optionen(QWidget* =0, Qt::WindowFlags=0);

  QSettings m_settings;

  public slots:
  void accept();
  void selectDbPath();

  signals:
  void setDefaultZoom(DisplayMode);

  private:
  Q_OBJECT
};

#endif
