/*
    Copyright (C) 2008  Johannes Bretscher

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include "tagsuche.h"

/*!
  constructor
*/
Tagsuche::Tagsuche(Datenbank *db, QWidget *p, Qt::WindowFlags f)
	: QDialog(p, f) {
  m_ui.setupUi(this);

  m_datenbank = db;
  QStringList tags = m_datenbank->getAllTags();
  tags.sort();
  m_ui.tagAuswahl->addItems(tags);
  m_ui.mussTags->addItems(tags);
  m_ui.darfnichtTags->addItems(tags);

  m_modeSelect.addButton(m_ui.selectSimple, 0);
  m_modeSelect.addButton(m_ui.selectExtended, 1);
  QObject::connect(&m_modeSelect, SIGNAL(buttonClicked(int)),
  	m_ui.searchDetails, SLOT(setCurrentIndex(int)));
}

/*!
  Ok wurde gedrueckt -> Suche starten, ergebnis mitteilen, dann beenden.
*/
void Tagsuche::accept() {
  switch(m_modeSelect.checkedId()) { // Other modes might be added in future
    case 0:
      emit selected(m_datenbank->findByTag(m_ui.tagAuswahl->currentText()));
      break;
    case 1: {
        QStringList mussList,
      		darfnichtList;
	QList<QListWidgetItem*> tempList;
	QList<QListWidgetItem*>::iterator itTag;
	tempList = m_ui.mussTags->selectedItems();
	for(itTag = tempList.begin();
	      tempList.end() != itTag;
	      itTag++) {
	  mussList.append((*itTag)->text());
	}
	tempList = m_ui.darfnichtTags->selectedItems();
	for(itTag = tempList.begin();
	      tempList.end() != itTag;
	      itTag++) {
	  darfnichtList.append((*itTag)->text());
	}
        emit selected(m_datenbank->findByTagList(mussList, darfnichtList));
      }
      break;
  }
  QDialog::accept();
}
