#ifndef __BILDAUSWAHL_H__
#define __BILDAUSWAHL_H__

/*
    Copyright (C) 2008  Johannes Bretscher

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <QToolBar>
#include <QComboBox>

//! \brief Erweiterte Toolbar zur Auswahl vorselektierter Bilder
class Bildauswahl : public QToolBar {
  QComboBox *m_bildlist;	//!< Direkter Zugriff auf die Bilder
  QAction *m_first,	//!< Zurueck zum ersten Bild
	*m_prev,	//!< Zurueck zum vorherigen Bild
	*m_selectBox,	//!< Behaelter fuer m_bildlist
	*m_next,	//!< Weiter zum naechsten Bild
	*m_last;	//!< Springe zum letzten Bild

  void updateStatus();

  private slots:
  void firstPressed();
  void prevPressed();
  void nextPressed();
  void lastPressed();
  void selectedImageChanged(const QString&);

  public:
  Bildauswahl(QWidget* =0);

  void setImageList(const QStringList&);

  signals:
  /*!
    Ein neues Bild wurde ausgewaehlt.
    \param bild Vollstaendiger Name des neuen Bildes
  */
  void bildGeaendert(const QString &bild);

  private:
  Q_OBJECT
};

#endif
