/*
    Copyright (C) 2008  Johannes Bretscher

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "optionen.h"
#include <QFileDialog>

/*!
  Constructor
*/
Optionen::Optionen(QWidget *p, Qt::WindowFlags f)
	:QDialog(p, f) {
  m_ui.setupUi(this);

  QObject::connect(m_ui.dbPathSearchButton, SIGNAL(clicked()),
	this, SLOT(selectDbPath())); 

  QString dbPath = m_settings.value("db/path", "*FALSE*").toString();
  m_ui.dbPathEdit->setText(dbPath);

  bool ok;
  DisplayMode displayMode = static_cast<DisplayMode>(m_settings.value("defaultDisplayMode", "*FALSE*").toInt(&ok));
  if(ok) {
    switch(displayMode) {
      case DM_ORIGINAL:
        m_ui.dpOriginal->setChecked(true);
	break;
      case DM_WIDTH:
        m_ui.dpWidth->setChecked(true);
	break;
      case DM_MAXWIDTH:
        m_ui.dpMaxWidth->setChecked(true);
	break;
      case DM_HEIGHT:
        m_ui.dpHeight->setChecked(true);
	break;
      case DM_MAXHEIGHT:
        m_ui.dpMaxHeight->setChecked(true);
	break;
    }
  }
}

/*!
  OK Knopf wurde gedrueckt.
*/
void Optionen::accept() {
  m_settings.setValue("db/path", m_ui.dbPathEdit->text());

  if(m_ui.dpOriginal->isChecked()) {
    emit setDefaultZoom(DM_ORIGINAL);
  } else if(m_ui.dpWidth->isChecked()) {
    emit setDefaultZoom(DM_WIDTH);
  } else if(m_ui.dpMaxWidth->isChecked()) {
    emit setDefaultZoom(DM_MAXWIDTH);
  } else if(m_ui.dpHeight->isChecked()) {
    emit setDefaultZoom(DM_HEIGHT);
  } else if(m_ui.dpMaxHeight->isChecked()) {
    emit setDefaultZoom(DM_MAXHEIGHT);
  }

  QDialog::accept();
}

/*!
  Datenbankpfad aus Liste waehlen.
*/
void Optionen::selectDbPath() {
  QFileDialog fdia(this, tr("datenbankpfad"));
  
  fdia.setAcceptMode(QFileDialog::AcceptOpen);
  fdia.setFileMode(QFileDialog::DirectoryOnly);
  fdia.setViewMode(QFileDialog::List);
  fdia.exec();
  m_ui.dbPathEdit->setText(fdia.directory().absolutePath());

}
